@extends('dashboard.layouts.master')
@section('title')

@endsection
@section('css')
@include('dashboard.layouts.css')


@endsection
@section('body')
<script>
    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif

    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>

<!-- Page Sidebar Ends-->
<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;"> سياسة وخصوصية الموقع </h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="https://taqiviolet.com/admin/dashboard"
                                style="font-family: 'Cairo', sans-serif;">الرئيســـــية</a></li>
                        <li class="breadcrumb-item"> <a href="https://taqiviolet.com/admin/dashboard"
                                style="font-family: 'Cairo', sans-serif;">سياسة وخصوصية الموقع </a> </li>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <!-- Bookmark Start-->
                    <div class="bookmark">
                    </div>
                    <!-- Bookmark Ends-->
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h5 style="font-family: 'Cairo', sans-serif;"> سياسة وخصوصية الموقع </h5>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="{{ route('terms.update', $termCondition) }}"
                            enctype="multipart/form-data">
                            @csrf
                            @method('PUT')
                            <input type="hidden" name="id" value="{{ $termCondition->id ?? '' }}">

                            <div class="card">
                                <div class="card-body">
                                    <ul class="nav nav-tabs" id="language-tabs" role="tablist">
                                        <li class="nav-item">
                                            <a class="nav-link active" id="arabic-tab" data-bs-toggle="tab"
                                                href="#arabic-content" role="tab" aria-controls="arabic-content"
                                                aria-selected="true" style="font-family: 'Cairo', sans-serif;">اللغة
                                                العربية</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" id="english-tab" data-bs-toggle="tab"
                                                href="#english-content" role="tab" aria-controls="english-content"
                                                aria-selected="false" style="font-family: 'Cairo', sans-serif;">اللغة
                                                الإنجليزية</a>
                                        </li>
                                    </ul>

                                    <div class="tab-content" id="language-tab-content">
                                        <!-- Arabic Content -->
                                        <div class="tab-pane fade show active" id="arabic-content" role="tabpanel"
                                            aria-labelledby="arabic-tab">
                                            <div class="form-group mt-3">
                                                <label style="font-family: 'Cairo', sans-serif;">النص الطويل
                                                    بالعربية</label>
                                                <textarea name="terms_long_ar" class="form-control" rows="5"
                                                    required>{{ $termCondition->getTranslation('terms_long', 'ar') }}</textarea>
                                            </div>
                                            <div class="form-group mt-3">
                                                <label style="font-family: 'Cairo', sans-serif;">النص القصير
                                                    بالعربية</label>
                                                <textarea name="terms_short_ar" class="form-control" rows="3"
                                                    required>{{ $termCondition->getTranslation('terms_short', 'ar') }}</textarea>
                                            </div>
                                        </div>

                                        <!-- English Content -->
                                        <div class="tab-pane fade" id="english-content" role="tabpanel"
                                            aria-labelledby="english-tab">
                                            <div class="form-group mt-3">
                                                <label style="font-family: 'Cairo', sans-serif;">النص الطويل
                                                    بالإنجليزية</label>
                                                <textarea name="terms_long_en" class="form-control" rows="5"
                                                    required>{{ $termCondition->getTranslation('terms_long', 'en') }}</textarea>
                                            </div>
                                            <div class="form-group mt-3">
                                                <label style="font-family: 'Cairo', sans-serif;">النص القصير
                                                    بالإنجليزية</label>
                                                <textarea name="terms_short_en" class="form-control" rows="3"
                                                    required>{{ $termCondition->getTranslation('terms_short', 'en') }}</textarea>
                                            </div>
                                        </div>
                                    </div>

                                    <button class="btn btn-primary mt-3" type="submit">تحديث</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid Ends-->
</div>

@endsection
@section('js')
<!-- latest jquery -->
<script>
    ClassicEditor
    .create(document.querySelector('#editor1')) // المحرر العربي
    .catch(error => {
        console.error(error);
    });

ClassicEditor
    .create(document.querySelector('#editor2')) // المحرر الإنجليزي
    .catch(error => {
        console.error(error);
    });

</script>
@include('dashboard.layouts.js')

@endsection