@extends('dashboard.layouts.master')
@section('title')

@endsection
@section('css')
@include('dashboard.layouts.css')
@endsection
@section('body')
<script>
    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif

    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>


<!-- Page Sidebar Ends-->
<div class="page-body">
    <!-- Button trigger modal -->
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;"> شروط وأحكام جديدة </h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{ url('admin/dashboard') }}" style="font-family: 'Cairo', sans-serif;">
                                الرئيسيــــــة
                            </a>
                        </li>
                        <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;">
                            شروط وأحكام جديدة
                        </li>
                    </ol>
                </div>
                <div class="col-sm-6"></div>
            </div>
        </div>
    </div>

    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div>
                            <a href="{{ route('terms.create') }}" class="btn btn-success btn-lg"
                                style="font-family: 'Cairo', sans-serif;">
                                أضافـــــــة شروط وأحكام جديدة
                            </a>
                        </div>
                        <br>
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th style="font-family: 'Cairo', sans-serif;">العنوان (عربي)</th>
                                        <th style="font-family: 'Cairo', sans-serif;">التفاصيل القصيرة (عربي)</th>
                                        <th style="font-family: 'Cairo', sans-serif;">العمليات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($termConditions as $termCondition)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $termCondition->terms_long }}</td>
                                        <td>{{ $termCondition->terms_short }}</td>

                                        <td>
                                            <a class="btn btn-success"
                                                href="{{ route('terms.edit', $termCondition->id) }}">
                                                <i class="fa fa-edit"></i>
                                            </a>
                                            <form action="{{ route('terms.destroy', $termCondition->id) }}"
                                                method="POST" style="display: inline;">
                                                @csrf
                                                @method('DELETE')
                                                <button class="btn btn-danger" type="submit"><i
                                                        class="fa fa-remove"></i></button>
                                            </form>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid Ends-->
</div>

@endsection
@section('js')
<!-- latest jquery -->
@include('dashboard.layouts.js')


@endsection