<?php

namespace App\Http\Controllers\Api\Main;

use App\Models\State;
use App\Http\Resources\StateResource;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class StateController extends Controller
{
    public function index(Request $request)
    {
        $lang = $request->query('lang', 'en'); // افتراضيًا الإنجليزية إذا لم يتم تحديد اللغة
        $states = State::all();

        return response()->json([
            'message' => $lang == 'ar' ? 'تم جلب البيانات بنجاح' : 'States retrieved successfully',
            'data' => StateResource::collection($states),
        ], 200);
    }
}
