<?php

namespace App\Http\Controllers\MobileApp;

use App\Http\Controllers\Controller;
use App\Models\Governorate;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Http\Resources\GovernorateResource;
class GovernoratesController extends Controller
{

    public function getGovernoratesWithCities()
    {
        try {
            $governorates = Governorate::with('cities')->get();
            if ($governorates->isEmpty()) {
                \Log::info('No governorates found');
            }
            return response()->json([
                'status' => 'success',
                'message' => 'Governorates with cities retrieved successfully',
                'data' => GovernorateResource::collection($governorates),
            ], 200);
        } catch (\Illuminate\Database\QueryException $e) {
            \Log::error('Database error in getGovernoratesWithCities: ' . $e->getMessage());
            return response()->json([
                'status' => 'error',
                'message' => 'Database error occurred',
                'error' => $e->getMessage(),
            ], 500);
        } catch (\Exception $e) {
            \Log::error('General error in getGovernoratesWithCities: ' . $e->getMessage(), ['trace' => $e->getTraceAsString()]);
            return response()->json([
                'status' => 'error',
                'message' => 'Something went wrong while retrieving data',
                'error' => $e->getMessage(),
            ], 500);
        }
    }
    /**
     * Get all governorates
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    // public function index(Request $request)
    // {
    //     try {
    //         $governorates = Cache::remember('governorates_' . Request::header('Accept-Language', 'ar'), 3600, function () {
    //             return Governorate::all()->map(function ($governorate) {
    //                 return [
    //                     'id' => $governorate->id,
    //                     'name' => $governorate->name, // Uses Translatable Trait
    //                 ];
    //             });
    //         });

    //         return response()->json([
    //             'status' => 'success',
    //             'message' => [
    //                 'en' => 'Governorates retrieved successfully',
    //                 'ar' => 'تم استرجاع المحافظات بنجاح'
    //             ],
    //             'data' => $governorates,
    //         ], 200);
    //     } catch (\Exception $e) {
    //         \Log::error('Error in index: ' . $e->getMessage(), ['trace' => $e->getTraceAsString()]);
    //         return response()->json([
    //             'status' => 'error',
    //             'message' => [
    //                 'en' => 'Something went wrong while retrieving data',
    //                 'ar' => 'حدث خطأ أثناء جلب البيانات'
    //             ],
    //             'error' => $e->getMessage(),
    //         ], 500);
    //     }
    // }
}