<?php

namespace App\Http\Controllers\MobileApp;

use App\Http\Controllers\Controller;
use App\Http\Resources\VendorResource;
use App\Models\Vendor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
class ServiceCenterController extends Controller
{
    public function index(Request $request)
    {
        try {
            $locale = app()->getLocale();
            $cacheKey = 'services_' . $locale;

            $services = Cache::remember($cacheKey, 3600, function () {
                return Vendor::with('city')
                    ->where('is_active', true)->where('type', 2)
                    ->whereNull('deleted_at')->orderBy('id')->get();
            });

            return response()->json([
                'status' => 'success',
                'message' => trans('messages.retrieve_services'),
                'data' => VendorResource::collection($services),
            ], 200);
        } catch (\Exception $e) {
            Log::error('Error retrieving services', [
                'query' => $request->all(),
                'locale' => app()->getLocale(),
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
            ]);
            return response()->json([
                'status' => 'error',
                'message' => trans('messages.failed_to_retrieve_vendors'),
                'debug' => app()->environment('local') ? $e->getMessage() : null,
            ], 500);
        }
    }
    public function show($id)
    {

        try {
            $locale = app()->getLocale();
            $cacheKey = "services_$id" . $locale;

            $services = Cache::remember($cacheKey, 3600, function () use ($id) {
                return Vendor::with('city')->find($id);
            });

            return response()->json([
                'status' => 'success',
                'message' => trans('messages.retrieve_services'),
                'data' => new VendorResource($services),
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => trans('messages.failed_to_retrieve_vendors'),
                'debug' => app()->environment('local') ? $e->getMessage() : null,
            ], 500);
        }
    }
}