<?php
namespace App\Http\Controllers\MobileApp;

use App\Http\Controllers\Controller;
use App\Http\Resources\VendorResource;
use App\Models\Vendor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;

class VendorController extends Controller
{
    /**
     * Display a listing of vendors
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(Request $request)
    {
        try {
            $locale = app()->getLocale();
            $cacheKey = 'vendors_' . $locale;

            $vendors = Cache::remember($cacheKey, 3600, function () {
                return Vendor::with('city')
                    ->where('is_active', true)
                    ->whereNull('deleted_at')
                    ->orderBy('id')
                    ->get();
            });

            return response()->json([
                'status' => 'success',
                'message' => trans('messages.vendors_retrieved'),
                'data' => VendorResource::collection($vendors),
            ], 200);
        } catch (\Exception $e) {
            Log::error('Error retrieving vendors', [
                'query' => $request->all(),
                'locale' => app()->getLocale(),
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
            ]);
            return response()->json([
                'status' => 'error',
                'message' => trans('messages.failed_to_retrieve_vendors'),
                'debug' => app()->environment('local') ? $e->getMessage() : null,
            ], 500);
        }
    }
}