<?php

namespace App\Http\Requests\MobileApi;

use Illuminate\Validation\Rule;
use Illuminate\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\ValidationException;

class StoreCarForSaleRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return auth()->guard('sanctum')->check(); // Allow any authenticated user
    }
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'model_id' => 'required|exists:models,id',
            'image' => 'required|string|max:255', // Adjust to 'file' if uploading images
            'price' => 'required|numeric|min:0',
            'mileage' => 'required|integer|min:0',
            'description' => 'required|string|max:1000',
            'inspection_location' => 'nullable|string|max:255',
            'whatsapp_number' => 'nullable|string|max:20',
            'phone_number' => 'nullable|string|max:20',
            'installment_available' => 'nullable|boolean',
            'notes' => 'nullable|string|max:1000',
            'transmission_type' => ['nullable', Rule::in(['1', '0'])],
            'production_year' => 'nullable|integer|min:1900|max:' . (date('Y') + 1),
        ];
    }

    /**
     * Get custom error messages for validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'model_id.required' => trans('messages.custom.model_id.required'),
            'model_id.exists' => trans('messages.custom.model_id.exists'),
            'image.required' => trans('messages.custom.image.required'),
            'image.string' => trans('messages.custom.image.string'),
            'image.max' => trans('messages.custom.image.max'),
            'price.required' => trans('messages.custom.price.required'),
            'price.numeric' => trans('messages.custom.price.numeric'),
            'price.min' => trans('messages.custom.price.min'),
            'mileage.required' => trans('messages.custom.mileage.required'),
            'mileage.integer' => trans('messages.custom.mileage.integer'),
            'mileage.min' => trans('messages.custom.mileage.min'),
            'description.required' => trans('messages.custom.description.required'),
            'description.string' => trans('messages.custom.description.string'),
            'description.max' => trans('messages.custom.description.max'),
            'inspection_location.string' => trans('messages.custom.inspection_location.string'),
            'inspection_location.max' => trans('messages.custom.inspection_location.max'),
            'whatsapp_number.string' => trans('messages.custom.whatsapp_number.string'),
            'whatsapp_number.max' => trans('messages.custom.whatsapp_number.max'),
            'phone_number.string' => trans('messages.custom.phone_number.string'),
            'phone_number.max' => trans('messages.custom.phone_number.max'),
            'installment_available.boolean' => trans('messages.custom.installment_available.boolean'),
            'notes.string' => trans('messages.custom.notes.string'),
            'notes.max' => trans('messages.custom.notes.max'),
            'transmission_type.in' => trans('messages.custom.transmission_type.in'),
            'production_year.integer' => trans('messages.custom.production_year.integer'),
            'production_year.min' => trans('messages.custom.production_year.min'),
            'production_year.max' => trans('messages.custom.production_year.max'),
        ];
    }


}