<?php

namespace App\Http\Requests\MobileApi;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class StoreFeedbackRequest extends FormRequest
{
    public function authorize()
    {
        return true; // Public endpoint, no authorization needed
    }

    public function rules()
    {
        return [
            'name' => ['required', 'string', 'max:255'],
            'phone' => ['required', 'string', 'max:20'],
            'message' => ['required', 'string', 'max:1000'],
        ];
    }

    public function messages()
    {
        $locale = $this->header('Accept-Language', 'ar');
        $locale = in_array($locale, ['ar', 'en']) ? $locale : 'ar';

        return $locale === 'ar' ? [
            'name.required' => 'الاسم مطلوب.',
            'name.string' => 'الاسم يجب أن يكون نصًا.',
            'name.max' => 'الاسم يجب ألا يتجاوز 255 حرفًا.',
            'phone.required' => 'رقم الهاتف مطلوب.',
            'phone.string' => 'رقم الهاتف يجب أن يكون نصًا.',
            'phone.max' => 'رقم الهاتف يجب ألا يتجاوز 20 حرفًا.',
            'message.required' => 'الرسالة مطلوبة.',
            'message.string' => 'الرسالة يجب أن تكون نصًا.',
            'message.max' => 'الرسالة يجب ألا تتجاوز 1000 حرف.',
        ] : [
            'name.required' => 'The name is required.',
            'name.string' => 'The name must be a string.',
            'name.max' => 'The name must not exceed 255 characters.',
            'phone.required' => 'The phone number is required.',
            'phone.string' => 'The phone number must be a string.',
            'phone.max' => 'The phone number must not exceed 20 characters.',
            'message.required' => 'The message is required.',
            'message.string' => 'The message must be a string.',
            'message.max' => 'The message must not exceed 1000 characters.',
        ];
    }

    protected function failedValidation(Validator $validator)
    {
        $locale = $this->header('Accept-Language', 'ar');
        $locale = in_array($locale, ['ar', 'en']) ? $locale : 'ar';

        throw new HttpResponseException(response()->json([
            'status' => 'error',
            'message' => [
                'en' => 'Validation failed.',
                'ar' => 'فشل التحقق من الصحة.'
            ],
            'errors' => $validator->errors(),
        ], 422));
    }
}