<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CategoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $locale = $request->header('Accept-Language', 'ar');
        $locale = in_array($locale, ['ar', 'en']) ? $locale : 'ar';

        return [
            'id' => $this->id,
            'name' => is_array($this->name) ? ($this->name[$locale] ?? null) : (
                json_decode($this->name, true)[$locale] ?? null
            ),
            'is_active' => $this->is_active,
            'image' => $this->image,
            'parent_id' => $this->parent_id,
            // 'description' => is_array($this->description) ? ($this->description[$locale] ?? null) : (
            //     json_decode($this->description, true)[$locale] ?? null
            // ),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'parent' => new CategoryResource($this->whenLoaded('parent')),
            'children' => CategoryResource::collection($this->whenLoaded('children')),
            'spare_parts' => SparePartResource::collection($this->whenLoaded('spareParts')),
            'custom_part_requests' => CustomPartRequestResource::collection($this->whenLoaded('customPartRequests')),
        ];
    }
}