<?php
namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CustomPartRequestResource extends JsonResource
{
    public function toArray($request)
    {
        $locale = $request->header('Accept-Language', 'ar');
        $locale = in_array($locale, ['ar', 'en']) ? $locale : 'ar';

        return [
            'id' => $this->id,
            'model' => $this->model ? new ModelResource($this->model) : null,
            'category' => $this->category ? new CategoryResource($this->category) : null,
            'vendor_id' => $this->vendor_id,
            'vendor' => $this->vendor ? new VendorResource($this->vendor) : null,
            'description' => $this->description,
            'status' => $this->status,
            'items' => CustomPartRequestItemResource::collection($this->whenLoaded('items')),
            'created_at' => $this->created_at?->toIso8601String(),
            'updated_at' => $this->updated_at?->toIso8601String(),
        ];
    }
}