<?php
namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class GovernorateResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
'name' => json_decode($this->name)->ar ?? '',
            'cities' => CityResource::collection($this->whenLoaded('cities')),
        ];
    }
}