<?php
namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ModelResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $locale = $request->header('Accept-Language', 'ar');
        $locale = in_array($locale, ['ar', 'en']) ? $locale : 'ar';
        return [
            'id' => $this->id,
            'name' => is_array($this->name) ? ($this->name[$locale] ?? null) : (
                json_decode($this->name, true)[$locale] ?? null
            ),
            'year' => $this->year,
            'brand' => $this->brand ? new BrandResource($this->brand) : null,
            'car_category_id' => $this->car_category_id,
            'category_name' => $this->carCategory ? $this->carCategory->name : null,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}