<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class StateResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        $data = [
            'ID' => $this->id,
            'Name' => $this->name,
        ];

        // التحقق مما إذا كان الكائن يدعم الترجمة
        if (method_exists($this, 'getTranslatableAttributes')) {
            foreach ($this->getTranslatableAttributes() as $field) {
                $data[$field] = $this->getTranslation($field, app()->getLocale());
            }
        }

        return $data;
    }
}
