<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class UserCarResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $locale = app()->getLocale();
        return [
            'id' => $this->id,
            'model' => $this->carModel ? new ModelResource($this->carModel) : null,
            'user' => $this->user ? [
                'id' => $this->user->id,
                'name' => $this->user->full_name,
            ] : null,
            'name' => $this->getTranslatableField($this->name, $locale), // Handle translatable field
            'description' => $this->getTranslatableField($this->description, $locale), // Handle translatable field
            'manufacturing_year' => $this->manufacturing_year,
            'engine' => $this->engine,
            'chassis_number' =>$this->chassis_number ,
            'chassis_image' =>$this->chassis_image?asset('storage/'.$this->chassis_image):null ,
            'car_image' => $this->car_image?asset('storage/'.$this->car_image):null,
            'created_at' => $this->created_at->toDateTimeString(),
            'updated_at' => $this->updated_at->toDateTimeString(),
        ];
    }

    /**
     * Get translatable field value for the given locale.
     *
     * @param  mixed  $value
     * @param  string  $locale
     * @return string
     */
    private function getTranslatableField($value, $locale)
    {
        if (is_array($value)) {
            return $value[$locale] ?? $value['en'] ?? $value[array_key_first($value)] ?? '';
        }
        if (is_string($value) && is_array($decoded = json_decode($value, true))) {
            return $decoded[$locale] ?? $decoded['en'] ?? $decoded[array_key_first($decoded)] ?? $value;
        }
        return $value ?? '';
    }
}