<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class CarForSale extends Model
{
    use HasFactory, SoftDeletes;
    public $table = 'cars_for_sale';
    protected $fillable = [
        'model_id',
        'image',
        'price',
        'mileage',
        'description',
        'vendor_id',
        'inspection_location',
        'whatsapp_number',
        'phone_number',
        'installment_available',
        'notes',
        'transmission_type',
        'production_year',
        'user_id'
    ];

    public function model()
    {
        return $this->belongsTo(CarModel::class, 'model_id');
    }

    public function vendor()
    {
        return $this->belongsTo(Vendor::class);
    }
    public function user()
    {
        return $this->belongsTo(User::class); // Check foreign key
    }
}