<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CarModel extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'year', 'brand_id', 'car_category_id'];
    // protected $casts = [
    //     'name' => 'array',
    // ];
    protected $table = 'models';

    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }
    public function carCategory()
    {
        return $this->belongsTo(CarCategory::class);
    }

    public function spareParts()
    {
        return $this->hasMany(SparePart::class);
    }

    public function carsForSale()
    {
        return $this->hasMany(CarForSale::class);
    }

    public function userCars()
    {
        return $this->hasMany(UserCar::class);
    }

    public function customPartRequests()
    {
        return $this->hasMany(CustomPartRequest::class);
    }
}