<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cars_for_sale', function (Blueprint $table) {
            $table->id();
            $table->foreignId('model_id')->constrained()->onDelete('restrict');
            $table->string('image');
            $table->decimal('price', 10, 2);
            $table->integer('mileage');
            $table->string('type')->nullable();
            $table->text('description')->nullable();
            $table->foreignId('vendor_id')->constrained()->onDelete('cascade');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('car_for_sales');
    }
};