@extends('dashboard.layouts.master')
@section('title')

@endsection
@section('css')
@include('dashboard.layouts.css')


@endsection
@section('body')
<script>
    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif

    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>

<!-- Page Sidebar Ends-->
<div class="page-body">
    <!-- Modal -->
    <!-- Button trigger modal -->
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;"> معلومات عنا جديده </h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{url('admin/dashboard')}}"
                                style="font-family: 'Cairo', sans-serif;">الرئيسيــــــة</a></li>
                        <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;"> معلومات عنا جديده
                        </li>
                    </ol>
                </div>
                <div class="col-sm-6">
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <!-- DOM / jQuery  Starts-->
            <form class="needs-validation" method="POST" action="{{ route('about-us.update', $aboutUs) }}"
                enctype="multipart/form-data">

                @csrf
                @method('PUT')
                <div class="col-sm-12 col-xl-12 xl-100">
                    <div class="card">
                        <div class="card-body">
                            <ul class="nav nav-tabs" id="icon-tab" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link active" id="icon-home-tab" data-bs-toggle="tab" href="#icon-home"
                                        role="tab" aria-controls="icon-home" aria-selected="true"
                                        style="font-family: 'Cairo', sans-serif;">
                                        اللغـــة العربية
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="profile-icon-tab" data-bs-toggle="tab" href="#profile-icon"
                                        role="tab" aria-controls="profile-icon" aria-selected="false"
                                        style="font-family: 'Cairo', sans-serif;">
                                        اللغـــة الانجليزيـــة
                                    </a>
                                </li>
                            </ul>
                            <br>
                            <div class="tab-content" id="icon-tabContent">
                                <!-- Arabic Content -->
                                <div class="tab-pane fade show active" id="icon-home" role="tabpanel"
                                    aria-labelledby="icon-home-tab">
                                    <div class="row g-3">
                                        <div class="col-md-12">
                                            <label class="mr-sm-2" style="font-family: 'Cairo', sans-serif;">النص الطويل
                                                بالعربية</label>
                                            <textarea name="about_us_long_ar" class="form-control" rows="5" id="editor1"
                                                style="border:solid 1px #555;"
                                                required>{{ $aboutUs->getTranslation('about_us_long', 'ar') }}</textarea>
                                        </div>
                                    </div>
                                    <br>
                                    <div class="col-md-12">
                                        <label class="mr-sm-2" style="font-family: 'Cairo', sans-serif;">النص القصير
                                            بالعربية</label>
                                        <textarea name="about_us_short_ar" class="form-control" rows="3"
                                            style="border:solid 1px #555;"
                                            required>{{ $aboutUs->getTranslation('about_us_short', 'ar') }}</textarea>
                                    </div>
                                </div>

                                <!-- English Content -->
                                <div class="tab-pane fade" id="profile-icon" role="tabpanel"
                                    aria-labelledby="profile-icon-tab">
                                    <div class="row g-3">
                                        <div class="col-md-12">
                                            <label class="mr-sm-2" style="font-family: 'Cairo', sans-serif;">النص الطويل
                                                بالانجليزية</label>
                                            <textarea name="about_us_long_en" class="form-control" rows="5" id=""
                                                style="border:solid 1px #555;"
                                                required>{{ $aboutUs->getTranslation('about_us_long', 'en') }}</textarea>
                                        </div>
                                    </div>
                                    <br>
                                    <div class="col-md-12">
                                        <label class="mr-sm-2" style="font-family: 'Cairo', sans-serif;">النص القصير
                                            بالانجليزية</label>
                                        <textarea name="about_us_short_en" class="form-control" rows="3"
                                            style="border:solid 1px #555;"
                                            required>{{ $aboutUs->getTranslation('about_us_short', 'en') }}</textarea>
                                    </div>
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label>اسم</label>
                                <input class="form-control" type="text" name="name" value="{{ $aboutUs->name }}"
                                    required>
                            </div>

                            <div class="row g-3">
                                <div class="col-md-12">
                                    <label class="mr-sm-2" style="font-family: 'Cairo', sans-serif;">الصـــورة
                                        الخاصة</label>
                                    <input type="file" name="image_url" class="form-control"
                                        style="border:solid 1px #555;">
                                    @if($aboutUs->image_url)
                                    <img src="{{ asset('storage/' . $aboutUs->image_url) }}" alt="Current Image"
                                        width="100" class="mt-2">
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <button class="btn btn-primary" type="submit">تحديث</button>
            </form>
            <!-- DOM / jQuery  Ends-->
        </div>
    </div>
    <!-- Container-fluid Ends-->
</div>

@endsection
@section('js')
<!-- latest jquery -->
<script>
    ClassicEditor
    .create(document.querySelector('#editor1')) // المحرر العربي
    .catch(error => {
        console.error(error);
    });

ClassicEditor
    .create(document.querySelector('#editor2')) // المحرر الإنجليزي
    .catch(error => {
        console.error(error);
    });

</script>
@include('dashboard.layouts.js')

@endsection