@extends('admin.layouts.master')
@section('title')

@endsection
@section('css')
@include('admin.layouts.css')
@endsection
@section('body')
<div class="page-body">
    <!-- Modal -->
    <!-- Button trigger modal -->
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;">الصــــــور المتحركــــة</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{route('admin.home')}}"
                                style="font-family: 'Cairo', sans-serif;">الرئيسيـــــــة</a></li>
                        <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;">الصــور المتحركـــــــة
                        </li>
                    </ol>
                </div>
                <div class="col-sm-6">

                </div>
            </div>
        </div>
    </div>
    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <!-- DOM / jQuery  Starts-->
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div>
                            <button type="button" class="btn-success btn-lg" data-bs-toggle="modal"
                                data-bs-target="#bannerModal" style="font-family: 'Cairo', sans-serif;">
                                أضافـــــــة صــورة جـديــدة
                            </button>

                        </div>
                        <br>
                        <div class="table-responsive">
                            <table class="display datatables" id="dt-plugin-method">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Image</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($sliders as $slider)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>
                                            <img width="120" src="{{ asset('storage/' . $slider->image) }}"
                                                alt="Slider Image">
                                        </td>
                                        <td>
                                            <a href="{{ route('admin.sliders.edit', $slider->id) }}"
                                                class="btn btn-success">
                                                <i class="fa fa-edit"></i>
                                            </a>
                                            <form action="{{ route('admin.sliders.destroy', $slider->id) }}"
                                                method="POST" style="display: inline;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger">
                                                    <i class="fa fa-remove"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>


                    </div>
                </div>
            </div>
            <!-- DOM / jQuery  Ends-->
        </div>
    </div>
    <!-- Container-fluid Ends-->
</div>
<!-- Modal -->
<div class="modal fade" id="bannerModal" tabindex="-1" aria-labelledby="bannerModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="bannerModalLabel" style="font-family: 'Cairo', sans-serif;">أضـــــافة
                    صــــوره متحركـة</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form class="needs-validation" novalidate="" enctype="multipart/form-data" method="post"
                    action="{{route('admin.sliders.store')}}">
                    @csrf
                    <div class="mb-3">
                        <label> اختر صورة</label>
                        <input style="border:solid 1px #555" name="image" class="form-control" type="file"
                            aria-label="file example" required>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                        <button class="btn btn-primary" type="submit">حفظ</button>
                    </div>

                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
@include('admin.layouts.js')
@endsection