@extends('dashboard.layouts.master')
@section('title')

@endsection
@section('css')
@include('dashboard.layouts.css')
@endsection
@section('body')
<!-- Page Sidebar Ends-->
<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;"> مقالات </h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{url('admin/dashboard')}}"
                                style="font-family: 'Cairo', sans-serif;">الرئيسيــــــة</a></li>
                        <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;">مقالات</li>
                    </ol>
                </div>
                <div class="col-sm-6"></div>
            </div>
        </div>
    </div>

    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div>
                            @can('admin.blogs.create')
                            <a href="{{route('blogs.create')}}"><button class="btn-success btn-lg"
                                    style="font-family: 'Cairo', sans-serif;"> انشاء مقاله </button></a>
                            @endcan

                        </div>
                        <br>
                        <div class="table-responsive">
                            <table class="display datatables" id="dt-plugin-method">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th style="font-family: 'Cairo', sans-serif;">العنوان</th>
                                        <th style="font-family: 'Cairo', sans-serif;">المحتوى</th>
                                        <th style="font-family: 'Cairo', sans-serif;"> عنوان المدونه التي ينتمي لها
                                        </th>
                                        <th style="font-family: 'Cairo', sans-serif;">تاريخ الإنشاء</th>
                                        <th style="font-family: 'Cairo', sans-serif;"> الصوره </th>
                                        <th style="font-family: 'Cairo', sans-serif;"> الصوره الداخليه </th>
                                        <th style="font-family: 'Cairo', sans-serif;">العمليـــــات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 0; ?>
                                    @foreach($items as $blog)
                                    <tr>
                                        <?php $i++; ?>
                                        <td>{{$i}}</td>
                                        <td style="font-family: 'Cairo', sans-serif;">{{$blog->Title}}</td>
                                        <td style="font-family: 'Cairo', sans-serif;">{!! Str::limit($blog->Content, 20)
                                            !!}
                                        </td>
                                        <td style="font-family: 'Cairo', sans-serif;">
                                            @if($blog->id_blog)
                                            @php
                                            $blog_sel = App\Models\dashboard\Blog::where('id', $blog->id_blog)->first();
                                            @endphp
                                            @if($blog_sel)
                                            {{ $blog_sel->Title }}
                                            @else
                                            A/N
                                            @endif
                                            @else
                                            A/N
                                            @endif
                                        </td>
                                        <!-- Show a snippet of the content -->

                                        <td style="font-family: 'Cairo', sans-serif;">
                                            {{$blog->created_at->format('Y-m-d')}}</td>
                                        <td style="font-family: 'Cairo', sans-serif;">
                                            @if ($blog->image)
                                            <img width="80" height="80" src=" {{ asset('storage/'.$blog->image) }}">
                                            @else
                                            <span>No image available</span>
                                            @endif
                                        </td>
                                        <td style="font-family: 'Cairo', sans-serif;">
                                            @if ($blog->imageInside)
                                            <img width="80" height="80"
                                                src=" {{ asset('storage/'.$blog->imageInside) }}">
                                            @else
                                            <span>No image available</span>
                                            @endif
                                        </td>
                                        <td>

                                            @can('admin.blogs.edit')
                                            <a href="{{ route('blogs.edit', $blog->id) }}" class="btn btn-success">
                                                <i class="fa fa-edit"></i>
                                            </a>
                                            @endcan
                                            @can('admin.blogs.delete')
                                            <a href="#">
                                                <button class="btn btn-danger" type="button" data-bs-toggle="modal"
                                                    data-bs-target="#delete{{ $blog->id }}">
                                                    <i class="fa fa-remove"></i>
                                                </button>
                                            </a>
                                            @endcan
                                        </td>
                                    </tr>
                                    <!-- Delete Modal -->
                                    <div class="modal fade" id="delete{{ $blog->id }}" tabindex="-1" role="dialog"
                                        aria-labelledby="deleteModalLabel" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="deleteModalLabel"
                                                        style="font-family: 'Cairo', sans-serif;">تأكيد الحذف</h5>
                                                    <button class="btn-close" type="button" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    هل أنت متأكد أنك تريد حذف المدونة؟
                                                </div>
                                                <div class="modal-footer">
                                                    <button class="btn btn-secondary" type="button"
                                                        data-bs-dismiss="modal">إلغاء</button>
                                                    <form action="{{ route('blogs.destroy', $blog->id) }}" method="POST"
                                                        style="display: inline;">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button class="btn btn-danger" type="submit">حذف</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </tbody>
                            </table>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    ClassicEditor
    .create(document.querySelector('#editor1')) // المحرر العربي
    .catch(error => {
        console.error(error);
    });

ClassicEditor
    .create(document.querySelector('#editor2')) // المحرر الإنجليزي
    .catch(error => {
        console.error(error);
    });

</script>
@include('dashboard.layouts.js')


@endsection