@extends('admin.layouts.master')
@section('title')

@endsection
@section('css')
@include('admin.layouts.css')
@endsection
@section('body')
<script>
    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif

    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>

<!-- Page Sidebar Ends-->
<div class="page-body">
    <!-- Modal -->
    <!-- Button trigger modal -->
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;">الأقســـــــام الرئيسيـــــة</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{url('admin/dashboard')}}"
                                style="font-family: 'Cairo', sans-serif;">الرئيسيــــــة</a></li>
                        <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;">الأقســام الرئيسيـــــــة
                        </li>
                    </ol>
                </div>
                <div class="col-sm-6">
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <!-- DOM / jQuery  Starts-->
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <!-- <div>
                            <a href="{{route('admin.categories.create')}}" class="btn btn-success btn-lg"
                                style="font-family: 'Cairo', sans-serif;">
                                أضافـــــــة قســم جــديــد
                            </a>
                        </div> -->
                        <br>
                        <div class="table-responsive">
                            <table class="display datatables" id="dt-plugin-method">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th style="font-family: 'Cairo', sans-serif;">اســــم القســم</th>
                                        <th style="font-family: 'Cairo', sans-serif;">الصـــورة الخاصة بالموقع</th>
                                        <th style="font-family: 'Cairo', sans-serif;">العمليـــــات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 0; ?>
                                    @foreach($categories as $category)
                                    <tr>
                                        <?php $i++; ?>
                                        <td>{{ $i }}</td>
                                        <td>{{ $category->getTranslation('name','ar') }}</td>
                                        <td>
                                            @if ($category->image)
                                            <img width="120" src="{{  asset('storage/'.$category->image) }}">
                                            @else
                                            <span>No image available</span>
                                            @endif
                                        </td>
                                        <td>
                                            <button class="btn btn-success" type="button" data-bs-toggle="modal"
                                                data-bs-target="#edit{{ $category->id }}"><i
                                                    class="fa fa-edit"></i></button>

                                            <!-- <button class="btn btn-danger" type="button" data-bs-toggle="modal"
                                                data-bs-target="#delete{{ $category->id }}"><i
                                                    class="fa fa-remove"></i></button> -->
                                        </td>
                                    </tr>
                                    <!-- Edit Modal -->
                                    <div class="modal fade" id="edit{{ $category->id }}" tabindex="-1" role="dialog"
                                        aria-labelledby="editCategoryLabel" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="editCategoryLabel">تعديل القســم</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <form action="{{ route('admin.categories.update', $category->id) }}"
                                                        method="post" enctype="multipart/form-data">
                                                        @csrf
                                                        {{ method_field('PATCH') }}
                                                        <!-- Form fields for edit -->
                                                        <div class="mb-3">
                                                            <label>اســـم القســم</label>
                                                            <input class="form-control" type="text" name="name_ar"
                                                                value="{{ $category->getTranslation('name', 'ar') }}">
                                                        </div>
                                                        <div class="mb-3">
                                                            <label>اســـم القســم بالانجليزي</label>
                                                            <input class="form-control" type="text" name="name_en"
                                                                value="{{ $category->getTranslation('name', 'en') }}">
                                                        </div>

                                                        <div class="mb-3">
                                                            <label>الصـــورة الخاصة بالموقع</label>
                                                            <input class="form-control" type="file" name="image">
                                                            @if ($category->image)
                                                            <small>الصورة الحالية: <img
                                                                    src="{{ asset('storage/'.$category->image) }}"
                                                                    width="100" alt="Current Image"></small>
                                                            @endif
                                                        </div>

                                                        <div class="modal-footer">
                                                            <button class="btn btn-secondary" type="button"
                                                                data-bs-dismiss="modal">إغلاق</button>
                                                            <button class="btn btn-primary" type="submit">حفظ</button>
                                                        </div>
                                                    </form>
                                                </div>

                                            </div>
                                        </div>
                                    </div>

                                    <!-- Delete Modal -->
                                    <div class="modal fade" id="delete{{ $category->id }}" tabindex="-1" role="dialog"
                                        aria-labelledby="deleteCategoryLabel" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="deleteCategoryLabel">تأكيد الحذف</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    هل أنت متأكد أنك تريد حذف هذا القسم؟ هذا الإجراء لا يمكن التراجع
                                                    عنه.
                                                </div>
                                                <div class="modal-footer">
                                                    <button class="btn btn-secondary" type="button"
                                                        data-bs-dismiss="modal">إلغاء</button>
                                                    <form
                                                        action="{{ route('admin.categories.destroy', $category->id) }}"
                                                        method="POST" style="display: inline;">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button class="btn btn-danger" type="submit">حذف</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- DOM / jQuery  Ends-->
        </div>
    </div>
    <!-- Container-fluid Ends-->
</div>

@endsection
@section('js')
@include('admin.layouts.js')
@endsection