@extends('dashboard.layouts.master')
@section('title')

@endsection
@section('css')
@include('dashboard.layouts.css')
@endsection
@section('body')

<div class="page-body">
    <!-- Modal -->
    <!-- Button trigger modal -->
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;"> الشركاء </h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{url('admin/dashboard')}}"
                                style="font-family: 'Cairo', sans-serif;">الرئيسيــــــة</a></li>
                        <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;">الشركاء</li>
                    </ol>
                </div>
                <div class="col-sm-6">
                </div>
            </div>
        </div>
    </div>
    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <!-- DOM / jQuery  Starts-->
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div>
                            @can('admin.partners.create')
                            <!-- Trigger button for adding partner -->
                            <button type="button" class="btn btn-success btn-lg" data-bs-toggle="modal"
                                data-bs-target="#partnerModal">
                                أضــــافة
                            </button>
                            @endcan

                        </div>
                        <br>
                        <div class="table-responsive">
                            <table class="display datatables" id="dt-plugin-method">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th
                                            style="font-family: 'Cairo', sans-serif;font-weight:400;font-size:12px;text-align:center">
                                            الاسم
                                        </th>
                                        <th
                                            style="font-family: 'Cairo', sans-serif;font-weight:400;font-size:12px;text-align:center">
                                            الوصف
                                        </th>
                                        <th
                                            style="font-family: 'Cairo', sans-serif;font-weight:400;font-size:12px;text-align:center">
                                            الشعار
                                        </th>
                                        <th
                                            style="font-family: 'Cairo', sans-serif;font-weight:400;font-size:12px;text-align:center">
                                            العمليــــات
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 0; ?>
                                    @foreach($partners as $partner)
                                    <tr>
                                        <?php $i++; ?>
                                        <td>{{$i}}</td>
                                        <td>
                                            {{$partner->Name}}
                                        </td>
                                        <td style="font-family: 'Cairo', sans-serif;">{{$partner->Description}}</td>
                                        <td style="font-family: 'Cairo', sans-serif;">
                                            <img src="{{ asset('storage/'.$partner->LogoURL) }}" alt="Partner Logo"
                                                width="50" height="50">
                                        </td>
                                        <td>
                                            @can('admin.partners.edit')
                                            <button class="btn btn-success" type="button" data-bs-toggle="modal"
                                                data-bs-target="#edit{{$partner->id}}">
                                                <i class="fa fa-edit"></i>
                                            </button>
                                            @endcan
                                            @can('admin.partners.delete')
                                            <button class="btn btn-danger" type="button" data-bs-toggle="modal"
                                                data-bs-target="#delete{{$partner->id}}">
                                                <i class="fa fa-remove"></i>
                                            </button>
                                            @endcan
                                        </td>
                                    </tr>

                                    <!-- Edit Partner Modal -->
                                    <div class="modal fade" id="edit{{$partner->id}}" tabindex="-1"
                                        aria-labelledby="editPartnerModalLabel" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="editPartnerModalLabel">تعديل شريك</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <form enctype="multipart/form-data" method="post"
                                                        action="{{route('partners.update', $partner->id)}}">
                                                        @csrf
                                                        @method('PUT')
                                                        <div class="mb-3">
                                                            <label for="editName" class="form-label">الأسم</label>
                                                            <input type="text" class="form-control" id="editName"
                                                                name="Name" value="{{ $partner->Name }}" required>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label for="editDescription"
                                                                class="form-label">الوصف</label>
                                                            <textarea class="form-control" id="editDescription"
                                                                name="Description">{{ $partner->Description }}</textarea>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label for="editLogoURL" class="form-label">الشعار</label>
                                                            <input type="file" class="form-control" id="editLogoURL"
                                                                name="LogoURL">
                                                            <small class="text-muted">اترك الحقل فارغًا إذا كنت لا تريد
                                                                تغيير الشعار</small>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary"
                                                                data-bs-dismiss="modal">إلغاء</button>
                                                            <button type="submit" class="btn btn-primary">حفظ
                                                                التغييرات</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Delete Partner Modal -->
                                    <div class="modal fade" id="delete{{$partner->id}}" tabindex="-1"
                                        aria-labelledby="deletePartnerModalLabel" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="deletePartnerModalLabel">حذف شريك</h5>
                                                    <button class="btn-close" type="button" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <form action="{{route('partners.destroy',$partner->id)}}" method="post">
                                                    @csrf
                                                    @method('DELETE')
                                                    <input id="id" type="hidden" name="id" value="{{ $partner->id }}">
                                                    <div class="modal-body">هل أنت متأكد من عملية الحذف؟</div>
                                                    <div class="modal-footer">
                                                        <button class="btn btn-secondary" type="button"
                                                            data-bs-dismiss="modal">إلغاء</button>
                                                        <button class="btn btn-danger" type="submit">حذف</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <!-- DOM / jQuery  Ends-->
        </div>
    </div>
    <!-- Container-fluid Ends-->
</div>
<!-- Add Partner Modal -->
<div class="modal fade" id="partnerModal" tabindex="-1" aria-labelledby="addPartnerModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addPartnerModalLabel">أضافة شريك جديد</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form enctype="multipart/form-data" method="post" action="{{route('partners.store')}}">
                    @csrf
                    <div class="mb-3">
                        <label for="Name" class="form-label">الأسم</label>
                        <input type="text" class="form-control" id="Name" name="Name" required>
                    </div>
                    <div class="mb-3">
                        <label for="Description" class="form-label">الوصف</label>
                        <textarea class="form-control" id="Description" name="Description"></textarea>
                    </div>
                    <div class="mb-3">
                        <label for="LogoURL" class="form-label">الشعار</label>
                        <input type="file" class="form-control" id="LogoURL" name="LogoURL" required>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                        <button type="submit" class="btn btn-primary">حفظ</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@endsection
@section('js')
@include('dashboard.layouts.js')


@endsection