@extends('dashboard.layouts.master')
@section('title')

@endsection
@section('css')
@include('dashboard.layouts.css')
@endsection
@section('body')
<div class="page-body">
    <!-- Modal -->
    <!-- Button trigger modal -->
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3> اماكن الصور </h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{url('admin/dashboard')}}">الرئيسيـــــــــة</a></li>
                        <li class="breadcrumb-item"> اماكن الصور </li>
                    </ol>
                </div>
                <div class="col-sm-6">
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <!-- DOM / jQuery  Starts-->
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div>
                            @can('admin.positionimage.create')
                            <button type="button" class="btn-success btn-lg" data-bs-toggle="modal"
                                data-bs-target="#bannerModal" style="font-family: 'Cairo', sans-serif;">
                                أضافـــــــة مكان جـديــد
                            </button>
                            @endcan


                        </div>
                        <br>
                        <div class="table-responsive">
                            <table class="display datatables" id="dt-plugin-method">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th style="font-family: 'Cairo', sans-serif;"> مكان الصور </th>
                                        <th style="font-family: 'Cairo', sans-serif;"> وصف </th>
                                        <th style="font-family: 'Cairo', sans-serif;"> عمليات </th>

                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 0; ?>
                                    @foreach($positions as $support)
                                    <tr style="text-align: center">
                                        <?php $i++; ?>
                                        <td>{{$i}}</td>
                                        <td>{{$support->Name}}</td>
                                        <td>{{$support->Description}}</td>
                                        <td>
                                            @can('admin.positionimage.delete')
                                            <button class="btn btn-sm btn-danger" type="button" data-bs-toggle="modal"
                                                data-original-title="test"
                                                data-bs-target="#exampleModal{{$support->id}}"><i
                                                    class="fa fa-remove"></i>
                                            </button>
                                            @endcan
                                        </td>
                                    </tr>

                                    <!-- delete_modal_Grade -->
                                    <div class="modal fade" id="exampleModal{{$support->id}}" tabindex="-1"
                                        role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLabel">حذف الرسالة</h5>
                                                    <button class="btn-close" type="button" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <form action="{{route('position-image.destroy',$support->id)}}"
                                                    method="post">
                                                    {{ method_field('Delete') }}
                                                    @csrf
                                                    <input id="id" type="hidden" name="id" class="form-control"
                                                        value="{{ $support->id }}">
                                                    <div class="modal-body">هل أنت متاكد من حذف الرسالة</div>
                                                    <div class="modal-footer">
                                                        <button class="btn btn-primary" type="button"
                                                            data-bs-dismiss="modal">غلق</button>
                                                        <button class="btn btn-secondary" type="submit">حذف</button>
                                                    </div>
                                                </form>

                                            </div>
                                        </div>
                                    </div>

                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <!-- DOM / jQuery  Ends-->
        </div>
    </div>
    <!-- Container-fluid Ends-->
</div>
@include('dashboard.pages.positionslider.add')
@endsection
@section('js')
@include('dashboard.layouts.js')

@endsection