@extends('admin.layouts.master')
@section('title')

@endsection
@section('css')
@include('admin.layouts.css')
@endsection
@section('body')
<script>
    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif

    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>

<!-- Page Sidebar Ends-->
<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;">اضــــافة منتـــج جديــــد</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="https://taqiviolet.com/admin/dashboard"
                                style="font-family: 'Cairo', sans-serif;">الرئيســـــية</a></li>
                        <li class="breadcrumb-item"> <a href="https://taqiviolet.com/admin/dashboard"
                                style="font-family: 'Cairo', sans-serif;">المنتجــــات</a> </li>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <!-- Bookmark Start-->
                    <div class="bookmark">
                    </div>
                    <!-- Bookmark Ends-->
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h5 style="font-family: 'Cairo', sans-serif;">اضافـــــــة منتـــج جديـــد</h5>
                    </div>
                    <div class="card-body">
                        <form class="needs-validation" method="POST" enctype="multipart/form-data"
                            action="{{ route('admin.products.update', $product->id) }}">
                            @csrf
                            @method('PUT')
                            <div class="col-sm-12 col-xl-12 xl-100">
                                <div class="card">
                                    <div class="card-body">
                                        <ul class="nav nav-tabs" id="icon-tab" role="tablist">
                                            <li class="nav-item">
                                                <a class="nav-link active" id="icon-home-tab" data-bs-toggle="tab"
                                                    href="#icon-home" role="tab" aria-controls="icon-home"
                                                    aria-selected="true" style="font-family: 'Cairo', sans-serif;">
                                                    اللغة العربية </a>
                                            </li>
                                            <li class="nav-item">
                                                <a class="nav-link" id="profile-icon-tab" data-bs-toggle="tab"
                                                    href="#profile-icon" role="tab" aria-controls="profile-icon"
                                                    aria-selected="false" style="font-family: 'Cairo', sans-serif;">
                                                    اللغة الانجليزية </a>
                                            </li>
                                        </ul>
                                        <br>
                                        <div class="tab-content" id="icon-tabContent">
                                            <!-- Arabic Tab -->
                                            <div class="tab-pane fade show active" id="icon-home" role="tabpanel"
                                                aria-labelledby="icon-home-tab">
                                                <div class="row g-3">
                                                    <div class="col-md-6">
                                                        <label for="name_ar" class="mr-sm-2"
                                                            style="font-family: 'Cairo', sans-serif;">
                                                            اسم المنتج باللغة العربية
                                                        </label>
                                                        <input name="name_ar" class="form-control" id="name_ar"
                                                            type="text"
                                                            value="{{ $product->getTranslation('name','ar') }}">
                                                    </div>
                                                    <div class="col-md-6">
                                                        <label for="short_details_ar" class="mr-sm-2"
                                                            style="font-family: 'Cairo', sans-serif;">
                                                            وصف قصير باللغة العربية
                                                        </label>
                                                        <input name="short_details_ar" class="form-control"
                                                            id="short_details_ar" type="text"
                                                            value="{{ $product->getTranslation('short_description','ar') }}">
                                                    </div>
                                                </div>
                                                <br>
                                                <div class="col-md-12">
                                                    <label for="details_ar" class="mr-sm-2"
                                                        style="font-family: 'Cairo', sans-serif;">
                                                        وصف تفصيلي باللغة العربية
                                                    </label>
                                                    <textarea name="details_ar" id="editor_details_ar" rows="10"
                                                        class="form-control">
                                                        {{ $product->getTranslation('long_description','ar') }}
                                                    </textarea>
                                                </div>
                                                <div class="col-md-12">
                                                    <label for="sizes_measures_ar" class="mr-sm-2"
                                                        style="font-family: 'Cairo', sans-serif;">
                                                        وصف المقاسات باللغة العربية
                                                    </label>
                                                    <textarea name="sizes_measures_ar" id="editor_sizes_measures_ar"
                                                        rows="5" class="form-control">
                                                        {{ $product->getTranslation('sizes_measures','ar') }}
                                                    </textarea>
                                                </div>
                                                <div class="col-md-12">
                                                    <label for="delivery_restore_ar" class="mr-sm-2"
                                                        style="font-family: 'Cairo', sans-serif;">
                                                        سياسة الارجاع الخاصة بالمنتج باللغة العربية
                                                    </label>
                                                    <textarea name="delivery_restore_ar" id="editor3" rows="5"
                                                        class="form-control">{{ $product->getTranslation('delivery_restore','ar')  }}</textarea>
                                                </div>
                                            </div>
                                            <!-- English Tab -->
                                            <div class="tab-pane fade" id="profile-icon" role="tabpanel"
                                                aria-labelledby="profile-icon-tab">
                                                <div class="row g-3">
                                                    <div class="col-md-6">
                                                        <label for="name_en" class="mr-sm-2"
                                                            style="font-family: 'Cairo', sans-serif;">
                                                            اسم المنتج باللغة الإنجليزية
                                                        </label>
                                                        <input name="name_en" class="form-control" id="name_en"
                                                            type="text"
                                                            value="{{ $product->getTranslation('name','en') }}">
                                                    </div>
                                                    <div class="col-md-6">
                                                        <label for="short_details_en" class="mr-sm-2"
                                                            style="font-family: 'Cairo', sans-serif;">
                                                            وصف قصير باللغة الإنجليزية
                                                        </label>
                                                        <input name="short_details_en" class="form-control"
                                                            id="short_details_en" type="text"
                                                            value="{{ $product->getTranslation('short_description','en')  }}">
                                                    </div>
                                                </div>
                                                <div class="col-md-12">
                                                    <label for="details_en" class="mr-sm-2"
                                                        style="font-family: 'Cairo', sans-serif;">
                                                        وصف تفصيلي باللغة الإنجليزية
                                                    </label>
                                                    <textarea name="details_en" id="editor_details_en" rows="10"
                                                        class="form-control">
                                                        {{ $product->getTranslation('long_description','en') }}
                                                    </textarea>
                                                </div>
                                                <div class="col-md-12">
                                                    <label for="sizes_measures_en" class="mr-sm-2"
                                                        style="font-family: 'Cairo', sans-serif;">
                                                        وصف المقاسات باللغة الإنجليزية
                                                    </label>
                                                    <textarea name="sizes_measures_en" id="editor_sizes_measures_en"
                                                        rows="5" class="form-control">
                                                        {{ $product->getTranslation('sizes_measures','en') }}
                                                    </textarea>
                                                </div>

                                                <div class="col-md-12">
                                                    <label for="delivery_restore_en" class="mr-sm-2"
                                                        style="font-family: 'Cairo', sans-serif;">
                                                        سياسة الارجاع الخاصة بالمنتج باللغة الإنجليزية
                                                    </label>
                                                    <textarea name="delivery_restore_en" id="editor3" rows="5"
                                                        class="form-control">{{ $product->getTranslation('delivery_restore','en')  }}</textarea>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- Product Info Section -->
                            <div class="row g-3">
                                <div class="col-md-3">
                                    <label for="serail_no" class="mr-sm-2" style="font-family: 'Cairo', sans-serif;">كود
                                        المنتج</label>
                                    <input name="serail_no" class="form-control" id="serail_no" type="text"
                                        value="{{ $product->code }}">
                                </div>
                            </div>

                            <div class="row g-3">
                                <div class="col-md-3">
                                    <label for="old_price" class="mr-sm-2" style="font-family: 'Cairo', sans-serif;">سعر
                                        المنتج القديم</label>
                                    <input name="old_price" class="form-control" id="old_price" type="number"
                                        value="{{ $product->old_price }}">
                                </div>
                                <div class="col-md-3">
                                    <label for="current_price" class="mr-sm-2"
                                        style="font-family: 'Cairo', sans-serif;">سعر المنتج الحالي</label>
                                    <input name="new_price" class="form-control" id="current_price" type="number"
                                        value="{{ $product->new_price }}">
                                </div>
                            </div>

                            <br>
                            <div class="row g-3">
                                <div class="col-md-3">
                                    <label for="quantity" class="mr-sm-2"
                                        style="font-family: 'Cairo', sans-serif;">الكمية</label>
                                    <input name="quantity" class="form-control" id="quantity" type="number"
                                        value="{{ $product->num_stock }}">
                                </div>

                                <div class="col-md-3">
                                    <label for="CategoryID" class="mr-sm-2"
                                        style="font-family: 'Cairo', sans-serif;">اسم القسم</label>
                                    <div class="box dropdown-content">
                                        <select name="CategoryID" id="category_id" class="form-control">
                                            <option value="" disabled>اختر القسم</option>
                                            @foreach ($categories as $category)
                                            <option value="{{ $category->id }}" {{ $product->category_id ==
                                                $category->id
                                                ? 'selected' : '' }}>
                                                {{ $category->getTranslation('name','ar') ??null }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="row g-3">
                                <img width="50px" height="100px" style="width: 100px"
                                    src="{{url('storage/'.$product->image)}}">
                                <div class="col-md-8 mb-5">
                                    <label for="image" class="mr-sm-2" style="font-family: 'Cairo', sans-serif;">الصورة
                                        الرئيسية</label>
                                    <input name="image" class="form-control" type="file" accept="image/*">
                                </div>
                                <div class="col-md-8 mb-5">
                                    <label for="images" class="mr-sm-2" style="font-family: 'Cairo', sans-serif;">معرض
                                        الصور</label>
                                    @if (!empty($product->images) && is_iterable($product->images))
                                    @foreach ($product->images as $image)
                                    <img width="120px" src="{{ url('storage/'.$image->image_path) }}"
                                        alt="Product Gallery Image">
                                    @endforeach
                                    @else
                                    <p>No images available.</p>
                                    @endif
                                    <input name="images[]" class="form-control" type="file" accept="image/*" multiple>
                                </div>
                            </div>

                            <button class="btn btn-primary" type="submit">حفـــظ التعديلات</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid Ends-->
</div>

@endsection
@section('js')
<!-- latest jquery -->
<script>
    document.addEventListener("DOMContentLoaded", function () {
        // List of unique editor IDs
        const editorIDs = [
            'editor_details_en',
            'editor_sizes_measures_en',
            'editor_details_ar',
            'editor_sizes_measures_ar'
        ];

        // Initialize CKEditor for each textarea
        editorIDs.forEach(editorId => {
            CKEDITOR.replace(editorId, {
                language: editorId.includes('_ar') ? 'ar' : 'en' // Set language based on ID
            });
        });
    });
</script>
@include('admin.layouts.js')

@endsection