@extends('admin.layouts.master')
@section('title')

@endsection
@section('css')
@include('admin.layouts.css')
@endsection
@section('body')
<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3> المنتجـــــات </h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item active"> المنتجـــــات </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <a href="{{ route('admin.products.create') }}" class="btn btn-success btn-lg">
                            أضـــــافة منتـــج جديــــد
                        </a>
                    </div>

                    <div class="card-body table-responsive">
                        <table class="display" id="advance-12">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>الصورة</th>
                                    <th>الاسم</th>
                                    <th>العنوان</th>
                                    <th>السعر الحالي</th>
                                    <th>السعر القديم</th>
                                    <th>الكمية</th>
                                    <th>القسم</th>
                                    <th>معرض الصور</th>
                                    <th> كود المنتج </th>
                                    <th> حالة المنتج في المتجر </th>
                                    <th> حالة المنتج في النشر</th>
                                    <th>تاريخ الاضافه</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($products as $product)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <!-- Image -->
                                    <td>
                                        @if (isset($product->image) && file_exists(public_path('storage/' .
                                        $product->image)))
                                        <img width="70" src="{{ asset('storage/' . $product->image) }}"
                                            alt="{{ implode(' ', array_slice(explode(' ', $product->getTranslation('name', 'ar')), 0, 5)) }}">
                                        @else
                                        <span>No image available</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if (isset($product->name) && $product->name)
                                        {{ $product->getTranslation('name','ar') }}
                                        @else
                                        <span>Unavailable</span>
                                        @endif
                                    </td>
                                    <!-- Alt Title (Limited to 5 words) -->
                                    <td>
                                        @isset($product->alt_title)
                                        {{ implode(' ', array_slice(explode(' ', $product->alt_title), 0, 5)) }}
                                        @else
                                        <span>Unavailable</span>
                                        @endif
                                    </td>
                                    <!-- New Price -->
                                    <td>{{ $product->new_price ?? 'Not Available' }}</td>
                                    <!-- Old Price -->
                                    <td>{{ $product->old_price ?? 'Not Available' }}</td>
                                    <!-- Stock -->
                                    <td>{{ $product->num_stock ?? 'Not Available' }}</td>
                                    <td>
                                        @isset($product->category)
                                        {{ implode(' ', array_slice(explode(' ',
                                        $product->category->getTranslation('name', 'ar')), 0, 5)) }}
                                        @else
                                        <span>No category</span>
                                        @endif

                                    </td>
                                    <td>
                                        @if($product->images->isNotEmpty())
                                        <img src="{{ url('storage/'.$product->images->first()->image_path) }}"
                                            alt="Product Image" width="100">
                                        @else
                                        Not Available
                                        @endif
                                    </td>
                                    <!-- Product Code -->
                                    <td>{{ $product->code ?? 'No code' }}</td>
                                    <td>{{ $product->status->name ?? 'لا يوجد حاله' }}</td>
                                    <td>{{ $product->active->name ?? 'يوجد مشكله ' }}</td>
                                    <!-- Created At -->
                                    <td>{{ $product->created_at->format('Y-m-d') }}</td>
                                    <td>
                                        <a href="{{ route('admin.products.edit', $product->id) }}"
                                            class="btn btn-success">
                                            <i class="fa fa-edit"></i> تعديل
                                        </a>
                                        <button class="btn btn-danger" data-bs-toggle="modal"
                                            data-bs-target="#deleteModal{{ $product->id }}">
                                            <i class="fa fa-remove"></i> حذف
                                        </button>
                                        <button class="btn btn-success" data-bs-toggle="modal"
                                            data-bs-target="#updateStatus{{ $product->id }}">
                                            <i class="fas fa-ellipsis-v"></i> نشر
                                        </button>
                                    </td>
                                </tr>
                                <div class="modal fade" id="deleteModal{{ $product->id }}" tabindex="-1"
                                    aria-labelledby="deleteModalLabel" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="deleteModalLabel">حذف المنتج</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                    aria-label="إغلاق"></button>
                                            </div>
                                            <div class="modal-body">
                                                هل أنت متأكد أنك تريد حذف هذا المنتج؟
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary"
                                                    data-bs-dismiss="modal">إلغاء</button>
                                                <form action="{{ route('admin.products.destroy', $product->id) }}"
                                                    method="post" style="display:inline;">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger">حذف</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal fade" id="updateStatus{{ $product->id }}" tabindex="-1"
                                    aria-labelledby="updateStatusLabel" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="updateStatusLabel">تحديث الحالة</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                    aria-label="إغلاق"></button>
                                            </div>
                                            <form action="{{ route('admin.products.updateStatus', $product->id) }}"
                                                method="POST">
                                                @csrf
                                                @method('PUT')
                                                <div class="modal-body">
                                                    <label for="status" class="form-label">اختر الحالة:</label>
                                                    <select name="status_id" id="status" class="form-select" required>
                                                        <option value="1" {{ $product->status_active_id == 1 ?
                                                            'selected' : '' }}>معلق</option>
                                                        <option value="2" {{ $product->status_active_id == 2 ?
                                                            'selected' : '' }}>تمت الموافقه</option>
                                                        <option value="3" {{ $product->status_active_id == 3 ?
                                                            'selected' : '' }}>تم الرفض</option>
                                                    </select>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-bs-dismiss="modal">إلغاء</button>
                                                    <button type="submit" class="btn btn-success">تحديث</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>


                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
@include('admin.layouts.js')

@endsection