@extends('dashboard.layouts.master')
@section('title')

@endsection
@section('css')
@include('dashboard.layouts.css')
@endsection
@section('body')
<script>
    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif

    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>

<!-- Page Sidebar Ends-->
<div class="page-body">
    <!-- Modal -->
    <!-- Button trigger modal -->
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;"> معلومات عنا جديده </h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{url('admin/dashboard')}}"
                                style="font-family: 'Cairo', sans-serif;">الرئيسيــــــة</a></li>
                        <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;"> أضافـــــــة تقييم عميل
                            جديد
                        </li>
                    </ol>
                </div>
                <div class="col-sm-6">
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <!-- DOM / jQuery  Starts-->
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div>
                            <!-- Button to Open Modal -->
                            <a href="#" class="btn btn-success btn-lg" data-bs-toggle="modal"
                                data-bs-target="#addReviewClientModal" style="font-family: 'Cairo', sans-serif;">
                                أضافـــــــة تقييم عميل جديد
                            </a>
                        </div>
                        <br>
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th style="font-family: 'Cairo', sans-serif;">الاسم</th>
                                        <th style="font-family: 'Cairo', sans-serif;">التقييم</th>
                                        <th style="font-family: 'Cairo', sans-serif;">معدل التقييم</th>
                                        <th style="font-family: 'Cairo', sans-serif;">الصورة</th>
                                        <th style="font-family: 'Cairo', sans-serif;">العمليات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($reviewClients as $review)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $review->name }}</td>
                                        <td>{{ $review->review }}</td>
                                        <td>{{ $review->rate }}/5</td>
                                        <td>
                                            @if ($review->image)
                                            <img width="80" height="80" src="{{ Storage::url($review->image) }}"
                                                alt="Review Image">
                                            @else
                                            <span>No image available</span>
                                            @endif
                                        </td>
                                        <td>
                                            <a class="btn btn-success" href="#" data-bs-toggle="modal"
                                                data-bs-target="#editReviewClientModal{{ $review->id }}">
                                                <i class="fa fa-edit"></i>
                                            </a>
                                            <form action="{{ route('review_clients.destroy', $review->id) }}"
                                                method="POST" style="display: inline;">
                                                @csrf
                                                @method('DELETE')
                                                <button class="btn btn-danger" type="submit">
                                                    <i class="fa fa-remove"></i>
                                                </button>
                                            </form>

                                        </td>
                                    </tr>
                                    <div class="modal fade" id="editReviewClientModal{{ $review->id }}" tabindex="-1"
                                        aria-labelledby="editReviewClientModalLabel{{ $review->id }}"
                                        aria-hidden="true">
                                        <div class="modal-dialog modal-lg">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title"
                                                        id="editReviewClientModalLabel{{ $review->id }}"
                                                        style="font-family: 'Cairo', sans-serif;">
                                                        تعديل تقييم العميل
                                                    </h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <form method="POST"
                                                        action="{{ route('review_clients.update', $review->id) }}"
                                                        enctype="multipart/form-data">
                                                        @csrf
                                                        @method('PUT')
                                                        <div class="col-sm-12 col-xl-12 xl-100">
                                                            <div class="card">
                                                                <div class="card-body">
                                                                    <ul class="nav nav-tabs" id="icon-tab"
                                                                        role="tablist">
                                                                        <li class="nav-item">
                                                                            <a class="nav-link active"
                                                                                id="icon-home-tab" data-bs-toggle="tab"
                                                                                href="#icon-home{{ $review->id }}"
                                                                                role="tab" aria-controls="icon-home"
                                                                                aria-selected="true"
                                                                                style="font-family: 'Cairo', sans-serif;">
                                                                                اللغـــة العربية
                                                                            </a>
                                                                        </li>
                                                                        <li class="nav-item">
                                                                            <a class="nav-link" id="profile-icon-tab"
                                                                                data-bs-toggle="tab"
                                                                                href="#profile-icon{{ $review->id }}"
                                                                                role="tab" aria-controls="profile-icon"
                                                                                aria-selected="false"
                                                                                style="font-family: 'Cairo', sans-serif;">
                                                                                اللغـــة الانجليزيـــة
                                                                            </a>
                                                                        </li>
                                                                    </ul>
                                                                    <br>
                                                                    <div class="tab-content" id="icon-tabContent">
                                                                        <div class="tab-pane fade show active"
                                                                            id="icon-home{{ $review->id }}"
                                                                            role="tabpanel"
                                                                            aria-labelledby="icon-home-tab">
                                                                            <div class="row g-3">
                                                                                <div class="col-md-12">
                                                                                    <label class="mr-sm-2"
                                                                                        style="font-family: 'Cairo', sans-serif;">التقييم
                                                                                        بالعربية</label>
                                                                                    <textarea name="review_ar"
                                                                                        class="form-control" rows="5"
                                                                                        style="border:solid 1px #555;"
                                                                                        required>{{ $review->getTranslation('review', 'ar') }}</textarea>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <!-- English Tab -->
                                                                        <div class="tab-pane fade"
                                                                            id="profile-icon{{ $review->id }}"
                                                                            role="tabpanel"
                                                                            aria-labelledby="profile-icon-tab">
                                                                            <div class="row g-3">
                                                                                <div class="col-md-12">
                                                                                    <label class="mr-sm-2"
                                                                                        style="font-family: 'Cairo', sans-serif;">التقييم
                                                                                        بالانجليزية</label>
                                                                                    <textarea name="review_en"
                                                                                        class="form-control" rows="5"
                                                                                        style="border:solid 1px #555;"
                                                                                        required>{{ $review->getTranslation('review', 'en') }}</textarea>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="row mb-3">
                                                                        <label>اسم العميل</label>
                                                                        <input class="form-control" type="text"
                                                                            name="name" value="{{ $review->name }}"
                                                                            required>
                                                                    </div>
                                                                    <div class="row mb-3">
                                                                        <label>تقييم (1-5)</label>
                                                                        <input class="form-control" type="number"
                                                                            name="rate" min="1" max="5"
                                                                            value="{{ $review->rate }}" required>
                                                                    </div>
                                                                    <div class="row g-3">
                                                                        <div class="col-md-12">
                                                                            <label class="mr-sm-2"
                                                                                style="font-family: 'Cairo', sans-serif;">الصورة</label>
                                                                            <input type="file" name="image"
                                                                                class="form-control"
                                                                                style="border:solid 1px #555;">
                                                                            @if ($review->image)
                                                                            <br>
                                                                            <img width="80" height="80"
                                                                                src="{{ Storage::url($review->image) }}">
                                                                            @endif
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary"
                                                                data-bs-dismiss="modal">إغلاق</button>
                                                            <button class="btn btn-primary" type="submit">تحديث</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@include('dashboard.pages.review_clients.modal_add')
@endsection
@section('js')
@include('dashboard.layouts.js')

@endsection