@extends('dashboard.layouts.master')
@section('title')

@endsection
@section('css')
@include('dashboard.layouts.css')

@endsection
@section('body')
<!-- Page Sidebar Ends-->
<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;"> مقالات </h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{url('admin/dashboard')}}"
                                style="font-family: 'Cairo', sans-serif;">الرئيسيــــــة</a></li>
                        <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;">قائمة الصلاحيات </li>
                    </ol>
                </div>
                <div class="col-sm-6"></div>
            </div>
        </div>
    </div>

    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif
    <!-- Start Main Content Area -->
    <div class="container-fluid">
        <div class="main-content d-flex flex-column">
            <div class="row justify-content-center">
                <div class="col-lg-9 col-md-8">
                    <div class="accordion-box-content">
                        <form method="POST" action="{{ route('roles.store') }}">
                            @csrf
                            <div class="tab-content clearfix">
                                <div class="tab-pane fade" id="general">
                                    <h4 class="tab-content-title">General</h4>
                                    <!-- Add any additional general fields here if needed -->
                                </div>
                                <div class="" id="permissions">
                                    <h4 class="tab-content-title">الصلاحيات</h4>
                                    <div class="form-group mb-4 col-lg-9">
                                        <label class="label text-secondary">الاسم</label>
                                        <div class="form-group">
                                            <input type="text" name="name" class="form-control text-dark h-55"
                                                placeholder="الاسم" value="{{ old('name') }}" required>
                                            @error('name')
                                            <div class="text-danger mt-2">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    @foreach($permissions->groupBy('group') as $group => $permissionsGroup)
                                    <div class="row">
                                        <div class="col-lg-12 col-md-12">
                                            <div class="col-md-12">
                                                <div class="row">
                                                    <div class="permission-parent-head clearfix">
                                                        <h5>{{ ucfirst($group) }}</h5>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="clearfix"></div>
                                            <div class="permission-group">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="permission-group-head">
                                                            <div class="row">
                                                                <div class="col-md-4 col-sm-4">
                                                                    <h6></h6>
                                                                </div>
                                                                <div class="col-md-8 col-sm-8"
                                                                    style="display: flex;justify-content: center;">
                                                                    <div class="btn-group permission-group-actions pull-right"
                                                                        style="justify-content: center;">
                                                                        <button type="button"
                                                                            class="btn btn-default deny-all">رفض
                                                                            للكل</button>
                                                                        <button type="button"
                                                                            class="btn btn-default allow-all">سماح
                                                                            للكل</button>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-12">
                                                            @foreach($permissionsGroup as $permission)
                                                            <div class="permission-row">
                                                                <div class="row d-flex">
                                                                    <div class="col-md-5 col-sm-4">
                                                                        <span class="permission-label">{{
                                                                            ucfirst($permission->action) }}</span>
                                                                    </div>

                                                                    <div class="col-md-7 col-sm-8">
                                                                        <div class="row">
                                                                            <div class="radio-btn clearfix d-flex gap-5"
                                                                                style="justify-content: center;">
                                                                                <div class="radio">
                                                                                    <input type="radio" value="0"
                                                                                        id="{{ $permission->group }}-{{ $permission->action }}-deny"
                                                                                        name="permissions[{{ $permission->group }}.{{ $permission->action }}]"
                                                                                        class="permission-deny">
                                                                                    <label
                                                                                        for="{{ $permission->group }}-{{ $permission->action }}-deny">رفض</label>
                                                                                </div>

                                                                                <div class="radio" style="">
                                                                                    <input type="radio" value="1"
                                                                                        id="{{ $permission->group }}-{{ $permission->action }}-allow"
                                                                                        name="permissions[{{ $permission->group }}.{{ $permission->action }}]"
                                                                                        class="permission-allow">
                                                                                    <label
                                                                                        for="{{ $permission->group }}-{{ $permission->action }}-allow">سماح</label>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            @endforeach
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>
                                <div class="form-group">
                                    <div class="col-md-10">
                                        <div class="d-flex justify-content-center">
                                            <button type="submit"
                                                class="btn btn-primary fw-medium text-white py-3 px w-100"> انشاء دور
                                                جديد

                                            </button>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
<script>
    // Function to handle the selection of permissions
    function handlePermissionAction(buttonClass, permissionClass) {
        $(buttonClass).on('click', function(event) {
            // Extract action type from the button's class
            const action = event.currentTarget.className.split(/\s+/)[2].split(/-/)[0];
            // Apply the action to the relevant radio buttons
            $(permissionClass.replace('?', action)).prop('checked', true);
        });
    }

    // Handle the permission actions for the parent actions
    handlePermissionAction(
        '.permission-parent-actions > .allow-all, .permission-parent-actions > .deny-all, .permission-parent-actions > .inherit-all',
        '.permission-?'
    );

    // Handle the permission actions for the group actions
    $('.permission-group-actions > .allow-all, .permission-group-actions > .deny-all, .permission-group-actions > .inherit-all').on('click', function(event) {
        const action = event.currentTarget.className.split(/\s+/)[2].split(/-/)[0];
        // Find the closest permission group and apply the action to its radio buttons
        $(this).closest('.permission-group').find(`.permission-${action}`).prop('checked', true);
    });

    // Handle delete API key action
    $('.delete-api-key').on('click', function(event) {
        $('#confirmation-form').attr('action', event.currentTarget.dataset.action);
    });

</script>
@include('dashboard.layouts.js')


@endsection