@extends('dashboard.layouts.master')
@section('title')

@endsection
@section('css')
@include('dashboard.layouts.css')
@endsection
@section('body')
<!-- Page Sidebar Ends-->
<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;"> قائمة الادوار </h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{url('admin/dashboard')}}"
                                style="font-family: 'Cairo', sans-serif;">الرئيسيــــــة</a></li>
                        <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;">قائمة الادوار </li>
                    </ol>
                </div>
                <div class="col-sm-6"></div>
            </div>
        </div>
    </div>

    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    <div class="container-fluid">
        <div class="main-content d-flex flex-column">
            <div class="card bg-white border-0 rounded-3 mb-4">
                <div class="card-body p-0">
                    <div class="d-flex justify-content-between align-items-center flex-wrap gap-3 p-4">
                        @can('admin.roles.create')
                        <a href="{{route('admin.roles.create')}}" class="btn btn-primary fw-medium text-white py-2 px-4"
                            style="font-size: small; text-decoration: none;">
                            <i class="ri-add-line"></i> اضافة دور جديد
                        </a>
                        @endcan

                    </div>
                    <div class="default-table-area style-two all-products">
                        <div class="table-responsive">
                            <table class="table align-middle">
                                <thead>
                                    <tr>
                                        <th scope="col"> الرقم التعريفي </th>
                                        <th scope="col"> الاسم </th>
                                        <th scope="col"> المجموعة </th>
                                        <th scope="col">الإجراءات</th> <!-- Action buttons -->
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($roles as $role)
                                    <tr>
                                        <td class="text-secondary">{{ $role->id}}</td>
                                        <td class="text-secondary">{{ $role->name }}</td>
                                        <td class="text-secondary">{{ $role->guard_name }}</td>
                                        <td>
                                            <div class="d-flex align-items-center gap-3">
                                                @can('admin.roles.edit')
                                                <a href="{{ route('roles.edit', $role->id) }}"
                                                    class="ps-0 border-0 bg-transparent lh-1 position-relative top-2"
                                                    data-bs-toggle="tooltip" data-bs-placement="top"
                                                    data-bs-title="Edit">
                                                    <i class="material-symbols-outlined fs-16 text-body">edit</i>
                                                </a>
                                                @endcan

                                                |
                                                @can('admin.roles.delete')
                                                <a href="{{ route('roles.destroy', $role->id) }}"
                                                    class="ps-0 border-0 bg-transparent lh-1 position-relative top-2 delete-role"
                                                    data-bs-toggle="tooltip" data-bs-placement="top" title="Delete">
                                                    <i class="material-symbols-outlined fs-16 text-danger">delete</i>
                                                </a>
                                                @endcan

                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        @if ($roles->count() > 0)
                        <nav aria-label="Page navigation">
                            <ul class="pagination">
                                <!-- Previous Page Link -->
                                @if ($roles->onFirstPage())
                                <li class="page-item disabled">
                                    <a class="page-link">السابق</a>
                                </li>
                                @else
                                <li class="page-item">
                                    <a class="page-link" href="{{ $roles->previousPageUrl() }}" aria-label="Previous">
                                        السابق </a>
                                </li>
                                @endif

                                <!-- Pagination Links -->
                                @foreach ($roles->links()->elements[0] as $page => $link)
                                @if ($page == $roles->currentPage())
                                <li class="page-item active" aria-current="page">
                                    <a class="page-link">{{ $page }}</a>
                                </li>
                                @else
                                <li class="page-item">
                                    <a class="page-link" href="{{ $link }}">{{ $page }}</a>
                                </li>
                                @endif
                                @endforeach

                                <!-- Next Page Link -->
                                @if ($roles->hasMorePages())
                                <li class="page-item">
                                    <a class="page-link" href="{{ $roles->nextPageUrl() }}" aria-label="Next">
                                        التالي</a>
                                </li>
                                @else
                                <li class="page-item disabled">
                                    <a class="page-link"> التالي</a>
                                </li>
                                @endif
                            </ul>
                        </nav>
                        @endif
                    </div>

                </div>
            </div>
            <div class="flex-grow-1"></div>
        </div>
    </div>
</div>
@endsection

@section('js')
<!-- Link Of JS File -->

<script>
    document.addEventListener('DOMContentLoaded', function () {
    document.querySelectorAll('.delete-role').forEach(function (element) {
        element.addEventListener('click', function (event) {
            event.preventDefault();
            if (confirm('Are you sure you want to delete this role?')) {
                // Create a form and submit it
                const form = document.createElement('form');
                form.method = 'POST';
                form.action = this.getAttribute('href'); // Ensure correct href is captured

                // Add CSRF token
                const tokenInput = document.createElement('input');
                tokenInput.type = 'hidden';
                tokenInput.name = '_token';
                tokenInput.value = '{{ csrf_token() }}'; // Laravel CSRF token
                form.appendChild(tokenInput);

                // Add method spoofing for DELETE
                const methodInput = document.createElement('input');
                methodInput.type = 'hidden';
                methodInput.name = '_method';
                methodInput.value = 'DELETE';
                form.appendChild(methodInput);

                // Append the form to body and submit
                document.body.appendChild(form);
                form.submit();
            }
        });
    });
});

</script>


@include('dashboard.layouts.js')

@endsection