@extends('admin.layouts.master')
@section('title')

@endsection
@section('css')
@include('admin.layouts.css')
@endsection
@section('body')


<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;"> صفحات الموقع </h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ url('admin/dashboard') }}"
                                style="font-family: 'Cairo', sans-serif;">الرئيسية</a></li>
                        <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;">صفحات الموقع</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <br>
                        <div class="table-responsive">
                            <table class="display datatables" id="dt-plugin-method">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th style="font-family: 'Cairo', sans-serif;">اسم الصفحة</th>
                                        <th style="font-family: 'Cairo', sans-serif;">محتوى الصفحة</th>
                                        <th style="font-family: 'Cairo', sans-serif;">العمليات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($siteStatistics as $statistic)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>
                                            {{-- Check if it's already an array, if not then decode --}}
                                            {{ is_array($statistic->name_page) ? $statistic->name_page['ar'] :
                                            json_decode($statistic->name_page)->ar }}
                                        </td>
                                        <td>
                                            {{-- Check if it's already an array, if not then decode --}}
                                            {{ is_array($statistic->value) ? Str::limit($statistic->value['ar'], 50) :
                                            Str::limit(json_decode($statistic->value)->ar, 50) }}
                                        </td>
                                        <td>
                                            <button class="btn btn-success" type="button" data-bs-toggle="modal"
                                                data-bs-target="#edit{{ $statistic->id }}">
                                                <i class="fa fa-edit"></i>
                                            </button>
                                        </td>
                                    </tr>
                                    <div class="modal fade" id="edit{{ $statistic->id }}" tabindex="-1"
                                        aria-labelledby="edit{{ $statistic->id }}Label" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="edit{{ $statistic->id }}Label">تعديل
                                                        البيانات</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <form action="{{ route('admin.static_pages.update', $statistic->id) }}"
                                                    method="POST">
                                                    @csrf
                                                    @method('PUT')
                                                    <div class="modal-body">
                                                        <div class="mb-3">
                                                            <label for="name_page" class="form-label">اسم الصفحة</label>
                                                            <input type="text" class="form-control" id="name_page"
                                                                name="name_page"
                                                                value="{{ is_array($statistic->name_page) ? $statistic->name_page['ar'] : json_decode($statistic->name_page)->ar }}"
                                                                disabled>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label for="editor-en-{{ $statistic->id }}"
                                                                class="form-label">محتوى الصفحة (إنجليزي)</label>
                                                            <textarea class="form-control"
                                                                id="editor-en-{{ $statistic->id }}" name="value[en]"
                                                                required>
                                                                {{ is_array($statistic->value) ? $statistic->value['en'] : json_decode($statistic->value)->en }}
                                                            </textarea>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label for="editor-ar-{{ $statistic->id }}"
                                                                class="form-label">محتوى الصفحة (عربي)</label>
                                                            <textarea class="form-control"
                                                                id="editor-ar-{{ $statistic->id }}" name="value[ar]"
                                                                required>
                                                                {{ is_array($statistic->value) ? $statistic->value['ar'] : json_decode($statistic->value)->ar }}
                                                            </textarea>
                                                        </div>

                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary"
                                                            data-bs-dismiss="modal">إغلاق</button>
                                                        <button type="submit" class="btn btn-primary">تحديث</button>
                                                    </div>
                                                </form>

                                            </div>
                                        </div>
                                    </div>

                                    @endforeach
                                </tbody>
                            </table>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- Add Site Statistic Modal -->
<div class="modal fade" id="statisticModal" tabindex="-1" aria-labelledby="addStatisticModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addStatisticModalLabel">أضافة إحصائية جديدة</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form method="POST" action="{{ route('admin.static_pages.store') }}">
                    @csrf
                    <div class="mb-3">
                        <label for="page_views" class="form-label"> الصفحات المعروضة</label>
                        <input type="text" class="form-control" id="page_views" name="page_views" required>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                        <button type="submit" class="btn btn-primary">حفظ</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@endsection
@section('js')

<script>
    document.addEventListener("DOMContentLoaded", function () {
        @foreach ($siteStatistics as $statistic)
            CKEDITOR.replace('editor-en-{{ $statistic->id }}', {
                language: 'en'
            });
            CKEDITOR.replace('editor-ar-{{ $statistic->id }}', {
                language: 'ar'
            });
        @endforeach
    });
</script>
@include('admin.layouts.js')


@endsection