@extends('admin.layouts.master')
@section('title')

@endsection
@section('css')
@include('admin.layouts.css')
@endsection
@section('body')
<script>
    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif

    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>

<!-- Page Sidebar Ends-->
<div class="page-body">
    <!-- Modal -->
    <!-- Button trigger modal -->
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;"> معلومات عن المدن </h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{url('admin/dashboard')}}"
                                style="font-family: 'Cairo', sans-serif;">الرئيسيــــــة</a></li>
                        <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;"> أضافـــــــة مدن
                            جديد
                        </li>
                    </ol>
                </div>
                <div class="col-sm-6">
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div>
                            <a href="#" class="btn btn-success btn-lg" data-bs-toggle="modal"
                                data-bs-target="#addAttributeModal">
                                أضف خاصية جديدة
                            </a>
                        </div>
                        <br>
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>الاسم</th>
                                        <th>السعر</th>
                                        <th>العمليات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($emirates as $attribute)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td> @php
                                            $name = json_decode($attribute->name, true);
                                            @endphp
                                            {{ $name['ar'] ?? 'Default Arabic Name' }}</td>
                                        <td>{{ $attribute->price }}</td>
                                        <td>
                                            <!-- Edit Button -->
                                            <a class="btn btn-success" href="#" data-bs-toggle="modal"
                                                data-bs-target="#editAttributeModal{{ $attribute->id }}">
                                                <i class="fa fa-edit"></i>
                                            </a>

                                            <!-- Delete Button -->
                                            <button class="btn btn-danger" data-bs-toggle="modal"
                                                data-bs-target="#deleteAttributeModal{{ $attribute->id }}">
                                                <i class="fa fa-remove"></i>
                                            </button>
                                        </td>
                                    </tr>

                                    <!-- Edit Attribute Modal -->
                                    <div class="modal fade" id="editAttributeModal{{ $attribute->id }}" tabindex="-1"
                                        aria-labelledby="editAttributeModalLabel{{ $attribute->id }}"
                                        aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title"
                                                        id="editAttributeModalLabel{{ $attribute->id }}"
                                                        style="font-family: 'Cairo', sans-serif;">
                                                        تعديل السمة
                                                    </h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <form method="POST"
                                                    action="{{ route('admin.emirates.update', $attribute->id) }}">
                                                    @csrf
                                                    @method('PUT')
                                                    <div class="modal-body">
                                                        <div class="form-group">
                                                            <label style="font-family: 'Cairo', sans-serif;"> الاسم
                                                                بالعربي </label>
                                                            <input type="text" name="name_ar" class="form-control"
                                                                value="{{$name['ar'] }}" required>
                                                        </div>
                                                        <div class="form-group">
                                                            <label style="font-family: 'Cairo', sans-serif;"> الاسم
                                                                بالانجليزي </label>
                                                            <input type="text" name="name_en" class="form-control"
                                                                value="{{$name['en'] }}" required>
                                                        </div>
                                                        <div class="form-group">
                                                            <label
                                                                style="font-family: 'Cairo', sans-serif;">السعر</label>
                                                            <input type="number" name="price" class="form-control"
                                                                value="{{ $attribute->price }}" required>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary"
                                                            data-bs-dismiss="modal">إغلاق</button>
                                                        <button type="submit" class="btn btn-primary">حفظ
                                                            التغييرات</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Delete Attribute Modal -->
                                    <div class="modal fade" id="deleteAttributeModal{{ $attribute->id }}" tabindex="-1"
                                        aria-labelledby="deleteAttributeModalLabel{{ $attribute->id }}"
                                        aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title"
                                                        id="deleteAttributeModalLabel{{ $attribute->id }}"
                                                        style="font-family: 'Cairo', sans-serif;">
                                                        حذف السمة
                                                    </h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <p style="font-family: 'Cairo', sans-serif;">هل أنت متأكد أنك تريد
                                                        حذف هذه السمة؟</p>
                                                </div>
                                                <div class="modal-footer">
                                                    <form action="{{ route('admin.emirates.destroy', $attribute->id) }}"
                                                        method="POST">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="button" class="btn btn-secondary"
                                                            data-bs-dismiss="modal">إغلاق</button>
                                                        <button type="submit" class="btn btn-danger">حذف</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Add Attribute Modal -->
    <div class="modal fade" id="addAttributeModal" tabindex="-1" aria-labelledby="addAttributeModalLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST" action="{{ route('admin.emirates.store') }}">
                    @csrf
                    <div class="modal-header">
                        <h5 class="modal-title" id="addAttributeModalLabel">إضافة خاصية جديدة</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label style="font-family: 'Cairo', sans-serif;">الاسم بالعربي</label>
                            <input type="text" name="name_ar" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label style="font-family: 'Cairo', sans-serif;">الاسم بالإنجليزي</label>
                            <input type="text" name="name_en" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label style="font-family: 'Cairo', sans-serif;">السعر</label>
                            <input type="number" name="price" class="form-control" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
                        <button type="submit" class="btn btn-primary">حفظ</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

</div>
@endsection
@section('js')
@include('admin.layouts.js')

@endsection